#!/usr/bin/perl
use Time::Local;
my $wanted = 'zebra';
my $syslogline = qr/^
  (\S{3})\s{1,2}           # $1 month name
  (\d{1,2})\s              # $2 day of month
  (\d\d):(\d\d):(\d\d)\s   # $3,$4,$5 hour, min, sec
  (\S+)\s                  # $6 host
  ([^[:]+)                 # $7 process name
  (?:\[(\d+)\])?           # $8 process id
  :\s
  (.+)                     # $9 log line
  $/x;

my $ip4 = qr|(\d{1,3}(?:\.\d{1,3}){3}/\d{1,2})|;
my $del = qr|^rib_process: $ip4: Removing existing|;
my $add = qr|^rib_process: $ip4: Adding route|;

my ($sec,$min,$hour,$mday,$mon,
  $year,$wday,$yday,$dst) = localtime time;
while (<>) {
  if (/$syslogline/) {
    my $time = utctime($1, $2, $3, $4, $5);
    if ($7 eq $wanted) {
      process_line($time,$6,$7,$8,$9);
    }
  }
}
sub utctime {
  my ($mon,$dom,$hour,$min,$sec) = @_;
  my %mons = (
    Jan => 0, Feb => 1, Mar => 2, Apr => 3,
    May => 4, Jun => 5, Jul => 6, Aug => 7,
    Sep => 8, Oct => 9, Nov => 10, Dec => 11,
  );
  my $mod = $mons{$mon};
  return timegm($sec,$min,$hour,$dom,$mod,$year);
}
sub process_line {
  my ($time,$host,$name,$pid,$text) = @_;
  if ($text =~ /$del/) {
    print "$time $host $name: remove $1\n";
  }
  elsif ($text =~ /$add/) {
    print "$time $host $name: add $1\n";
  } 
}

